#!/bin/bash
export datasets="Cora CiteSeer PubMed cs physics wikics OGBN-Arxiv"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export missing_rates_test="0.5"
export lambda_list="0.00001 0.0001 0.001 0.01 0.1 1 10"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=1

# uniform
for dataset in $datasets
do
for missing_rate in $missing_rates_test
do
for lamb in $lambda_list
do
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --lamb ${lamb} --lp_temp 1.0 --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu}
done
done
done

# structural
for dataset in $datasets
do
for missing_rate in $missing_rates_test
do
for lamb in $lambda_list
do
python main.py --dataset ${dataset} --missing_type structural --missing_rate ${missing_rate} --lamb ${lamb} --lp_temp 1.0 --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu}
done
done
done

# uniform
for dataset in $datasets
do
for missing_rate in $missing_rates_test
do
for lamb in $lambda_list
do
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --lamb ${lamb} --lp_temp 1.0 --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --max_only True
done
done
done

# structural
for dataset in $datasets
do
for missing_rate in $missing_rates_test
do
for lamb in $lambda_list
do
python main.py --dataset ${dataset} --missing_type structural --missing_rate ${missing_rate} --lamb ${lamb} --lp_temp 1.0 --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --max_only True
done
done
done